// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     net/interfaces/host_resolver_service.mojom
//

package org.chromium.mojom.net.interfaces;

public final class HostResolverRequestInfo extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 24;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public String host;
    public short port;
    public int addressFamily;
    public boolean isMyIpAddress;

    private HostResolverRequestInfo(int version) {
        super(STRUCT_SIZE, version);
    }

    public HostResolverRequestInfo() {
        this(0);
    }

    public static HostResolverRequestInfo deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static HostResolverRequestInfo decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        HostResolverRequestInfo result = new HostResolverRequestInfo(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.host = decoder0.readString(8, false);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.port = decoder0.readShort(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.isMyIpAddress = decoder0.readBoolean(18, 0);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.addressFamily = decoder0.readInt(20);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(host, 8, false);
        encoder0.encode(port, 16);
        encoder0.encode(isMyIpAddress, 18, 0);
        encoder0.encode(addressFamily, 20);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        HostResolverRequestInfo other = (HostResolverRequestInfo) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.host, other.host))
            return false;
        if (this.port != other.port)
            return false;
        if (this.addressFamily != other.addressFamily)
            return false;
        if (this.isMyIpAddress != other.isMyIpAddress)
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(host);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(port);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(addressFamily);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(isMyIpAddress);
        return result;
    }
}

